<?php
class SubscriptionsAdmin
{
  private $dbo = null;
  function __construct($dbo)
  {
    $this->dbo = $dbo;
  }
  function showList()
  {
    if(!$this->dbo){
      echo 'Lista subskrypcji nie jest dostępna.';
      return;
    }
    
    //Formowanie zapytania pobierającego listę subskrypcji.
    $query = "SELECT COUNT(su.UserId), s.Id, s.Nazwa ";
    $query .= "FROM Subskrypcje s LEFT JOIN Uzytkownicy_Subskrypcje su ";
    $query .= "ON su.SubskrypcjaId = s.Id ";
    $query .= "GROUP BY s.Id";
    
    if(!$result = $this->dbo->query($query)){
      return 'Błąd serwera. Brak listy subskrypcji.';
    }
    
    //Formularz, warstwa i początek tabeli HTML.
    echo '<form action = "index.php" method = "get">';
    echo '<div id="subscriptionsDiv">';
    echo '<input type="hidden" name="action" value="subscriptionsAdmin" />';
    echo '<input type="hidden" name="wtd" value="getEmailsList" />';
    echo '<table>';
    
    //Pobranie wyników zapytania.
    while($row = $result->fetch_row()){
      echo '<tr><td>';
      echo '<input type="checkbox" name="'.$row[1].'" />';
      echo '</td><td>'.$row[2].' ('.$row[0].')</td></tr>';
    }
    echo '<tr><td colspan="2">';
    echo 'Separator ';
    echo '<input type="text" name="separator" size="3" value=",\n" />';
    echo '</td></tr>';
    echo '<tr><td colspan="2">';
    echo '<input type="submit" value="Pobierz listę adresów e-mail">';
    echo '</td></tr>';
    echo '</table></div></form>';
  }
  function getEmailsList()
  {
    if(!$this->dbo){
      echo 'Błąd serwera. Dane nie są dostępne.';
    }
    
    //Ustalenie separatora
    if(isset($_GET['separator'])){
      $separator = $_GET['separator'];
      $separator = str_replace(
          array('\n', '\r', '\t'),
          array("\n", "\r", "\t"),
          $separator
          );
    }
    else{
      $separator = ",\n";
    }
    
    //Pobranie wszystkich identyfikatorów z tabeli Subskrypcje.
    $query = "SELECT Id FROM Subskrypcje";
    
    if(!$result = $this->dbo->query($query)){
      echo 'Błąd serwera. Lista nie jest dostępna.';
    }
    
    //Utworzenie ciągu identyfikatorów subskrypcji zaznaczonych w formularzu.
    $str = '0';
    while($row = $result->fetch_row()){
      if(isset($_GET[$row[0]])){
        $str .= ','.$row[0];
      }
    }
    
    //Formowanie zapytania pobierającego adresy e-mail.
    $query = 'SELECT DISTINCT email FROM Users u ';
    $query .= 'INNER JOIN Uzytkownicy_Subskrypcje su ';
    $query .= 'ON u.Id = su.userId ';
    $query .= 'WHERE su.SubskrypcjaId IN ('.$str.') ';
    
    if(!$result = $this->dbo->query($query)){
      echo 'Błąd serwera. Lista nie jest dostępna.';
      return;
    }
    
    //Ustawienie licznika wierszy.
    $rowsNo = $result->num_rows;
    $count = 0;
    
    //Wysłanie wyników do przeglądarki.
    header("Content-Type: text/plain");
    header("Content-Disposition: attachment; filename=subskrypcje.txt");
    
    while($row = $result->fetch_row()){
      echo $row[0];
      if(++$count < $rowsNo){
        echo $separator;
      }
    }
  }
}
?>